package com.ejie.aa17a.utilidades;

/**
 * 
 * @author francisco.galvez
 * 
 */
public class Aa17aConstantes {

	/**
	 * constructor Aa17aConstantes
	 */
	private Aa17aConstantes() {

	}

	public static final Integer ESTADO_ACTIVO = 1, ESTADO_INACTIVO = 0;

	public static final Integer FORMATO_HORA_23 = 23;

	public static final Integer FORMATO_MINUTO_59 = 59,
								FORMATO_MINUTO_00 = 0;

	public static final Integer FORMATO_SEGUNDO_59 = 59,
								FORMATO_SEGUNDO_00 = 0;

	public static final Integer HORA_24 = 24,
								HORA_23 = 23,
								HORA_22 = 22,
								HORA_21 = 21,
								HORA_20 = 20,
								HORA_19 = 19,
								HORA_18 = 18,
								HORA_17 = 17,
								HORA_16 = 16,
								HORA_15 = 15,
								HORA_14 = 14,
								HORA_13 = 13,
								HORA_12 = 12,
								HORA_11 = 11,
								HORA_10 = 10,
								HORA_09 = 9,
								HORA_08 = 8,
								HORA_07 = 7,
								HORA_06 = 6,
								HORA_05 = 5,
								HORA_04 = 4,
								HORA_03 = 3,
								HORA_02 = 2,
								HORA_01 = 1;

	public final static String FORMATO_FECHA_ES = "dd/MM/yyyy";
	public final static String FORMATO_FECHA_EU = "yyyy/MM/dd";

	public final static String FORMATO_FECHA_HORA_ES = "dd/MM/yyyy HH:mm:ss";
	public final static String FORMATO_FECHA_HORA_EU = "yyyy/MM/dd HH:mm:ss";

	public final static String FORMATO_FECHA_HORA_24_ES = "dd/MM/yyyy kk:mm";
	public final static String FORMATO_FECHA_HORA_24_EU = "yyyy/MM/dd kk:mm";

	/**
	 * Mantenimientos generales. Constantes de cada tipo de tabla dentro de la
	 * AA1700T00 ()
	 */
	public static final Integer TABLA_TIPO_LIMITE = 1;

	public static final String GEOJSON_TYPE_FEATURE_COLLECTION = "FeatureCollection",
								GEOJSON_TYPE_FEATURE = "Feature",
								GEOJSON_TYPE_GEOMETRY = "Point";

	//id de Banda que corresponde con el id del registro de BD asociado a la banda cuando no hay datos  
	public static final Long ID_BANDA_SIN_DATOS = new Long(0);

	//parametros de configuracion de las rutas de staticos para el mapa de geo euskadi
	public static final String CONFIG_STATICS_GIS_URL = "gis.path",
								CONFIG_STATICS_GIS_SB_URL = "gis.sb.path",
								CONFIG_KEY_GOOGLE_MAPS = "key.google.maps";

	public static final Integer DATO_VALIDADO = 1, //lo ha verificado el sistema
			DATO_VERIFICADO = 2; //Lo ha verificado una persona

	/*
	 * Formatos de exportación de los datos
	 */
	public static final String EXPORTAR_FORMATO_EXCEL = "xls",
								EXPORTAR_FORMATO_PDF = "pdf",
								EXPORTAR_FORMATO_CSV = "csv";

	//Tipos de parametros medio ambientales
	public static final Integer TIPO_PARAMETRO_CONTAMINANTE = 1,
								TIPO_PARAMETRO_METEREOLOGICO = 2;

	public static final Integer MAGIC_NUMBER_0 = 0,
								MAGIC_NUMBER_1 = 1,
								MAGIC_NUMBER_2 = 2,
								MAGIC_NUMBER_3 = 3,
								MAGIC_NUMBER_4 = 4,
								MAGIC_NUMBER_5 = 5,
								MAGIC_NUMBER_6 = 6,
								MAGIC_NUMBER_9 = 9,
								MAGIC_NUMBER_11 = 11,
								MAGIC_NUMBER_12 = 12,
								MAGIC_NUMBER_15 = 15,
								MAGIC_NUMBER_24 = 24,
								MAGIC_NUMBER_25 = 25,
								MAGIC_NUMBER_26 = 26,
								MAGIC_NUMBER_20 = 20,
								MAGIC_NUMBER_50 = 50,
								MAGIC_NUMBER_80 = 80,
								MAGIC_NUMBER_100 = 100,
								MAGIC_NUMBER_255 = 255;

	public static final Integer COLOR_CABECERA_INFORME_R = 74,
								COLOR_CABECERA_INFORME_G = 128,
								COLOR_CABECERA_INFORME_B = 182;

	public static final Integer COLOR_CRITERIOS_INFORME_R = 189,
								COLOR_CRITERIOS_INFORME_G = 189,
								COLOR_CRITERIOS_INFORME_B = 189;

	public static final Integer INFORME_DATOS_HORARIOS = 1,
								INFORME_DATOS_HISTORICOS_HORARIO = 2,
								INFORME_DATOS_HISTORICOS_DIARIO = 3;

	//imagen del logo del GV para los informes
	public static final String INFORME_IMAGEN_LOGO_GV = "/datos/aa17a/file/imagenes/aa17aLogoGV.gif";

	/*
	 * Constantes para controlar en la pantalla de exportación de datos históricos si hay que exportar datos horarios o diarios
	 */
	public static final Integer TIPO_DATOS_HORARIOS = 1,
								TIPO_DATOS_DIARIOS = 2;

	/*
	 * Constantes para definir los tipos de limites
	 */
	public static final Integer TIPO_LIMITE_DIARIO = 1,
								TIPO_LIMITE_HORARIO = 2;

	/*
	 * constantes para definir los id correspondientes a los limites definidos en la BD 
	 */
	public static final Integer LIMITE_HORARIO_ID = 1,
								LIMITE_DIARIO_ID = 2,
								LIMITE_ANUAL_ID = 3;

	/*
	 * Constantes para la construcción de un archivo csv
	 */
	public static final String CSV_SALTO_LINEA = "\n",
								CSV_SEPARADOR_CAMPO = ";";

	/*
	 * Formato decimal para los BigDecimal
	 */
	public static final String FORMAT_BIGDECIMAL = "#0.##";
}